;nyquist plug-in
;version 3
;type process
;categories "http://lv2plug.in/ns/lv2core#MixerPlugin"
;name "X-Fade"
;action "Applying Fade..."
;info "By Steve Daulton.\nReleased under GPL v2 Dec. 2009\nhttp://audacity.easyspacepro.com\n\nAdvanced Fade and Cross-Fade effect based on Bezier curves.\nFor description and help file select 'Help'.\n\n"

;control action "Choose Function or View help" choice "Fade In,Fade Out,X-fade In/Out,X-fade Out/In,Help,Reset" 0
;control p1 "Start Curve" real "" 0 -1 1
;control p2 "End Curve" real "" 0 -1 1
;control L1 "Max Amplification" real "dB" 0 -24 24
;control L2 "Min Amplification" real "dB" -96 -96 0

(setq fxname "x-fade v0.1.1 22-12-2009 http://easyspacepro.com")

(setq help (format nil
"X-Fade Help\n

This is an advanced fade effect for mono or stereo tracks
based on Bezier curves.
It can also produce cross-fades between two tracks.\n

The shape of the fade may be linear or curved.
'Start Curve' sets the initial shape of the curve and
'End Curve' sets the shape at the end of the selection.
Positive values produce convex curves and negative
values produce concave curves. A curve value of 0.0 
will produce a linear fade.\n

The maximum and minimum amplification levels allow
tracks to be faded from one level to another. By default
the max amplification is 0dB (no change) and the min
amplification -96dB (virtually silent).\n

Cross-Fading Two Tracks.
'X-Fade' requires that parts of 2 tracks are selected.
In/Out will fade the first track in and the second track out.
Out/In will fade the first track out and the second track in.
The curve settings are applied to the first track and the
second track will have a complimentary curve applied to it.\n
A good way to see what different fade curves are like is
to test it on generated tones.\n

If the plug-in produces the wrong type of fade, it may be
necessary to reset the plug-in by selecting 'Reset' from the
Function menu.
Viewing this Help file also performs an automatic reset."))

(setq L1 (db-to-linear L1))
(setq L2 (db-to-linear L2))

(setq msg "")

; set L1 and L2 according to fade type
(setq L L1)
(case action
   ((0 2) (setq L1 (min L1 L2))(setq L2 (max L L2)))
   ((1 3) (setq L1 (max L1 L2))(setq L2 (min L L2))))


;;     Function BEZIER
;Returns a bezier curve with relative length 1.0 at *control-srate*
;Variables used: P0x,P0y,P1x,P1y,P2x,P2y,P3x,P3y
;all values shold be positive.
;Equation for bezier curve: B(t)=((1-t)^3)*P0 + 3*((1-t)^2)*t*P1 + 3*((1-t)t^2)*P2 + (t^3)*P3
;End points of curve are P0 and P3
;Handles are P1 and P2
;Returns sound from (pwl-list ....)
(defun Bezier (P0x P0y P1x P1y P2x P2y P3x P3y)

   (let  ((p0x (abs p0x))(p0y (abs p0y))(p1x (abs p1x))(p1y (abs p1y))(p2x (abs p2x))(p2y (abs p2y))(p3x (abs p3x))(p3y (abs p3y))(coords ()))
      (dotimes (i 51)
         (setq var (/ i 50.0))
         (setq f0x (* (power (- 1.0 var) 3) p0x))
         (setq f0y  (* (power (- 1.0 var) 3) p0y))
         (setq f1x (* 3.0 (power (- 1.0 var) 2) var p1x))
         (setq f1y (* 3.0 (power (- 1.0 var) 2) var p1y))
         (setq f2x (* 3.0 (- 1.0 var) var var p2x))
         (setq f2y (* 3.0 (- 1.0 var) var var p2y))
         (setq f3x (* (power var 3) p3x))
         (setq f3y (* (power var 3) p3y))
         (setf coords (cons (+ f0x f1x f2x f3x) coords))
         (setf coords (cons (+ f0y f1y f2y f3y) coords)))
   (control-srate-abs *sound-srate* (pwlv-list (cdr (reverse coords))))
;(print (cdr (reverse coords)))
))

;;      Function - calc-xy
;Returns a vector "p" with x and y co-ordinates
(defun calc-xy (p1 p2 L1 L2)
; Adjust for L1 L2
(setq height (abs (- L1 L2)))

; For P1 fade in
   (defun fade-in1 (p)
      (if (>= p 0.0)
         (setq p1 (list 0.0 (+ L1 (* height p)))) ; convex curve
         (setq p1 (list (* -1.0 p) L1)))) ; concave curve
; For P1 fade out
   (defun fade-out1 (p)
      (if (>= p 0.0)
         (setq p1 (list  p1 L1)) ; convex curve
         (setq p1 (list 0.0 (+ L1 (* height p)))))) ; concave curve
;For P2 fade in
   (defun fade-in2 (p)
      (if (>= p 0.0)
         (setq p2 (list (- 1.0 p) L2)) ; convex curve
         (setq p2 (list 1.0 (+ L2 (* height p)))))) ; concave curve
;For P2 fade out
   (defun fade-out2 (p)
      (if (>= p 0.0)
         (setq p2 (list 1.0 (+ L2 (* height p)))) ; convex curve
         (setq p2 (list (+ 1.0 p) L2)))) ; concave curve
;Call fade functions      
   (if (< L1 L2)(fade-in1 p1)(fade-out1 p1))
   (if (< L1 L2)(fade-in2 p2)(fade-out2 p2))
(list (first p1)(second p1)(first p2)(second p2)))

;; Function to test if *scratch* is set
(defun scratch-test (fxname)
   (if (boundp '*scratch*)
      (if (stringp *scratch*)
         (if (string= *scratch* fxname) T NIL)
      nil)
   nil))
   
;; Function Fade
(defun fade (L1 L2 p1 p2)
   (setf handle (calc-xy p1 p2 L1 L2))
   (mult s (bezier 0 L1 (first handle)(second handle)(third handle)(fourth handle) 1 L2)))
   
;; Function x-fade
(defun x-fade (L1 L2 p1 p2)
   (if  (scratch-test fxname) ; T if *scratch* is set
      (progn (setq *scratch* nil)(fade L2 L1 p2 p1))
      (progn (setq *scratch* fxname)(fade L1 L2 p1 p2))))

; End of Functions

(if (string> msg "") msg 
   (case action
      ((0 1) (setq *scratch* nil)(fade L1 L2 p1 p2))
      ((2 3) (x-fade L1 L2 p1 p2))
      (4 (set '*scratch* NIL) help)
      (5 (setq *scratch* nil)(print "Reset Successful."))
      (T (setq msg "Not yet implemented"))
      ))
