;nyquist plug-in
;version 3
;type process
;name "Tone Control"
;action "Equalizing..."
;info "By Steve Daulton. http://audacity.easyspacepro.com\nReleased under GPL v2 Dec. 2009\n\nSelect help if required from menu.\n\n"

;control bass "Bass" real "[dB]" 0 -15 15
;control treb "Treble" real "[dB]" 0 -15 15
;control norm "Normalize Output" choice "Off,-3dB,0dB" 1
;control help "View Help" choice "No,Yes" 0

;; Sanitize user input
(defun sanitize (var minval maxval)
   (if  (> var maxval) maxval
      (if (< var minval) minval var)))

(setq bass (sanitize bass -15 15)) ; sanitize bass level
(setq treb (sanitize treb -15 15)) ; sanitize treble level

(defun viewhelp ()
   (format nil
"TONE CONTROL HELP.\n
To increase treble (high frequencies):
move Treble slider to right.
To increase bass (low frequencies):
move Bass slider to right.\n
To decrease Bass or Treble:
move the relevant slider to the left.
Set slider to centre [0] for no change.\n
The 'Normalize' option can help to avoid the output
from being too loud or too quiet.
If selected, 'Normalize Output' will adjust the overall
volume to approximately the level selected.
Normalize to 0dB is recommended for 32bit audio,
Normalize to -3dB is recommended for other bit depths.\n

TIPS:
Test on a short section before applying to the whole track.
If you do not like the result, use 'Undo' from the 'Edit' 
menu (or Ctrl+Z) to undo.\n

TECHNICAL DETAILS:
Equalization uses two second-order shelving Eq
filters. The half-gain point of the filters are set to
600Hz (bass) and 2kHz (kHz). 
Maximum boost/cut is +/-15dB.\n
Normalization amplifies the output to bring the
peak level up to 0dB or -3dB based on the peak level
of the 10 equally spaced selections of the output.
Both channels of stereo tracks are amplified
equally (linked).\n
A 10Hz eight-pole Butterworth highpass filter is applied
to the entire selection to remove sub-sonic frequencies.\n

Remember to de-select Help before using this effect."))

(setq eqz
   (highpass8 
   (eq-lowshelf 
      (eq-highshelf s 2000 treb 0.5)
      600 bass 0.5)
   10))
(setq s NIL)


;; normalize sound s-in to 'amp' dB for mono or stereo sounds
;; Gets max peak level from 10 evenly spaced sections from low samplerate copy
(defun normalize (s-in amp)
   (setq lorate (truncate (/ *sound-srate* 100)))
   (setq lofi (multichan-expand #'snd-avg s-in lorate lorate OP-PEAK))
   
   (defun getpeak (top)
      (let ((peak-s 0.0)(bignum (truncate *sound-srate*)))
         (dotimes (var 10 peak-s)
            (setq section (peak (extract (/ var 10.0)(/ (1+ var) 10.0) top) bignum))
            (setq peak-s (max peak-s section)))))
   
   (if (arrayp s-in)
         (setq peak-s (max (getpeak (aref lofi 0))(getpeak (aref lofi 1))))
         (setq peak-s (getpeak lofi)))
   (mult s-in (/ (db-to-linear amp) peak-s)))
; End of normalize

(defun process (s-in norm)
   (case norm
      (0 s-in)
      (1 (normalize s-in -3.0))
      (T (normalize s-in 0.0))))

(if (= help 1) (viewhelp)(process eqz norm))